package mygrenton.templates

import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.entity.widget.WidgetValueV2
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetValueV2 emptyWidget = createWidget()

def getWidgetType() {
    return "VALUE_V2"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 3) {
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 4){
            return 2
        } else if(deviceObjectDto.getObjectTypeId() == 23){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 53){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            return 2
        } else if(deviceObjectDto.getObjectTypeId() == 13) {
            return 23
        }
    } else if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 101 && virtualObjectDto.getTypeVersion() == 1){
            return 0
        } else if(virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1){
            return 2
        } else if(virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1){
            return 2
        } else if (virtualObjectDto.getObjectTypeId() == 151
                    || virtualObjectDto.getObjectTypeId() == 152
                    || virtualObjectDto.getObjectTypeId() == 153) {
            return 20
        }
    }
    return 1
}

WidgetValueV2 createWidget(){
    WidgetValueV2 widget = new WidgetValueV2();
    widget.setType("VALUE_V2")
    widget.setIcon("value")
    widget.setValueType("STRING")
    widget.setPrecision(2)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setValue(GroovyUtils.createEmptyStateEntity())
    emptyWidget.setLabel(textResources.getString("value"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetValueV2 widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 3) {
            widget.setIcon("value")
            setValuesForVariantOne(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 4){
            widget.setIcon("value")
            setValuesForVariantOne(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 23){
            setValuesForOnewSensor(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 53){
            widget.setIcon("value")
            setValuesForVariantOne(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            widget.setIcon("value")
            setValuesForVariantOne(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 55){
            setValuesForBattery(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 63){
            widget.setIcon("value")
            setValuesForOnewSensor(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 25){
            widget.setIcon("value")
            setValuesForVariantOne(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 56){
            widget.setIcon("value")
            setValuesForVariantOne(deviceObjectDto, widget)
        } else if (deviceObjectDto.getObjectTypeId() == 12
                || deviceObjectDto.getObjectTypeId() == 13
                || deviceObjectDto.getObjectTypeId() == 41
                || deviceObjectDto.getObjectTypeId() == 36
                || deviceObjectDto.getObjectTypeId() == 42
                || deviceObjectDto.getObjectTypeId() == 34
                || deviceObjectDto.getObjectTypeId() == 37
                || deviceObjectDto.getObjectTypeId() == 21
                || deviceObjectDto.getObjectTypeId() == 58
        ) {
            setValues(deviceObjectDto, widget, "UNKNOWN", "FLOAT")
        } else if (deviceObjectDto.getObjectTypeId() == 20) {
            setValues(deviceObjectDto, widget, "DEGREE","FLOAT")
        } else if (deviceObjectDto.getObjectTypeId() == 22) {
            setValues(deviceObjectDto, widget, "PERCENT","FLOAT")
        } else if (deviceObjectDto.getObjectTypeId() == 30
                || deviceObjectDto.getObjectTypeId() == 7) {
            widget.setIcon("value")
            setValues(deviceObjectDto, widget, "UNKNOWN", "INTEGER")
        }  else if (deviceObjectDto.getObjectTypeId() == 32) {
            widget.setIcon("value")
            setValues(deviceObjectDto, widget, "UNKNOWN", "INTEGER", "2")
        }
    } else if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 101 && virtualObjectDto.getTypeVersion() == 1){
            widget.setIcon("bell")
            setValues(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1){
            widget.setIcon("switch")
            setValues(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1){
            widget.setIcon("value")
            setValues(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 151){
            widget.setIcon("value")
            setValues(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 152){
            widget.setIcon("value")
            setValues(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 153){
            widget.setIcon("value")
            setValues(virtualObjectDto, widget)
        } else if (virtualObjectDto.getObjectTypeId() == 200) {
            widget.setIcon("value")
            setValues(virtualObjectDto, widget, "FLOAT", "14")
        } else if (virtualObjectDto.getObjectTypeId() == 201) {
            widget.setIcon("value")
            setValues(virtualObjectDto, widget, "FLOAT", "20")
        } else if ( virtualObjectDto.getObjectTypeId() == 203) {
            widget.setIcon("value")
            setValues(virtualObjectDto, widget, "FLOAT", "22")
        } else if (virtualObjectDto.getObjectTypeId() == 205) {
            widget.setIcon("value")
            setValues(virtualObjectDto, widget, "FLOAT", "19")
        } else if ((virtualObjectDto.getObjectTypeId() == 204
                || virtualObjectDto.getObjectTypeId() == 206)) {
            widget.setIcon("value")
            setValues(virtualObjectDto, widget, "FLOAT", "10")
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if (projectObject instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectObject
        if (deviceObjectDto.getObjectTypeId() == 3) {
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 4){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 23){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 53){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 55) {
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 58) {
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 63) {
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 25) {
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 56) {
            return true
        } else if (deviceObjectDto.getObjectTypeId() == 12
                || deviceObjectDto.getObjectTypeId() == 13
                || deviceObjectDto.getObjectTypeId() == 41
                || deviceObjectDto.getObjectTypeId() == 36
                || deviceObjectDto.getObjectTypeId() == 42
                || deviceObjectDto.getObjectTypeId() == 34
                || deviceObjectDto.getObjectTypeId() == 37
                || deviceObjectDto.getObjectTypeId() == 21
                || deviceObjectDto.getObjectTypeId() == 20
                || deviceObjectDto.getObjectTypeId() == 22
                || deviceObjectDto.getObjectTypeId() == 30
                || deviceObjectDto.getObjectTypeId() == 7
                || deviceObjectDto.getObjectTypeId() == 32
        ) {
            return true;
        }
    } else if (projectObject instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectObject
        if(virtualObjectDto.getObjectTypeId() == 101 && virtualObjectDto.getTypeVersion() == 1){
            return true
        } else if(virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1){
            return true
        } else if(virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1){
            return true
        } else if (virtualObjectDto.getObjectTypeId() == 151
                || virtualObjectDto.getObjectTypeId() == 152
                || virtualObjectDto.getObjectTypeId() == 153) {
            return true
        } else if (virtualObjectDto.getObjectTypeId() == 200
                || virtualObjectDto.getObjectTypeId() == 201
                || virtualObjectDto.getObjectTypeId() == 203
                || virtualObjectDto.getObjectTypeId() == 204
                || virtualObjectDto.getObjectTypeId() == 205
                || virtualObjectDto.getObjectTypeId() == 206) {
            return true
        }
    }
    return false
}

def setValuesForVariantOne(DeviceObjectDto deviceObjectDto, WidgetValueV2 widget){
    widget.setUnit("UNKNOWN")
    widget.setValueType("INTEGER")
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
}

def setValues(DeviceObjectDto deviceObjectDto, WidgetValueV2 widget, String unit, String valueType){
    setValues(deviceObjectDto, widget, unit, valueType, "0")
}

def setValues(DeviceObjectDto deviceObjectDto, WidgetValueV2 widget, String unit, String valueType, String index){
    widget.setIcon("value")
    widget.setUnit(unit)
    widget.setValueType(valueType)
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), index))
}

def setValuesForOnewSensor(DeviceObjectDto deviceObjectDto, WidgetValueV2 widget){
    widget.setIcon("temperature")
    widget.setUnit("DEGREE")
    widget.setValueType("FLOAT")
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
}

def setValues(VirtualObjectDto virtualObjectDto, WidgetValueV2 widget){
    widget.setUnit("UNKNOWN")
    widget.setValueType("INTEGER")
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
}

def setValues(VirtualObjectDto virtualObjectDto, WidgetValueV2 widget, String valueType){
    widget.setUnit("UNKNOWN")
    widget.setValueType(valueType)
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
}

def setValues(VirtualObjectDto virtualObjectDto, WidgetValueV2 widget, String valueType, String index){
    widget.setUnit("UNKNOWN")
    widget.setValueType(valueType)
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), index))
}

def setValuesForBattery(DeviceObjectDto deviceObjectDto, WidgetValueV2 widget){
    widget.setIcon("battery_status_1")
    widget.setUnit("PERCENT")
    widget.setValueType("INTEGER")
    widget.setPrecision(2)
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
}



